//
//  MCBackupSchedule.h
//  MCPostgresPersistence
//
//  Created by Fraser Kuyvenhoven on 06/11/08.
//  Copyright 2008 Marketcircle. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCBackupSchedule : NSObject
{
	NSMutableDictionary *dataDictionary;
}

+ (MCBackupSchedule *)defaultBackupSchedule;

- (id)initWithDataDictionary:(NSDictionary *)aDataDictionary;
- (NSMutableDictionary *)dataDictionary;

// Derived Accessors

- (int)day;
- (void)setDay:(int)aDay;

- (int)hour;
- (void)setHour:(int)anHour;

- (BOOL)canUseCustom;
- (BOOL)useCustom;
- (void)setUseCustom:(BOOL)useCustomFlag;

- (NSDictionary *)customDays;
- (void)setCustomDays:(NSDictionary *)aCustomDays;

- (NSDictionary *)customHours;
- (void)setCustomHours:(NSDictionary *)aCustomHours;

- (NSDictionary *)customHours;

- (NSCalendarDate *)nextBackupDate;
- (NSCalendarDate *)nextBackupDateAfterDate:(NSCalendarDate *)startDate;

- (NSString *)backupPath;
- (void)setBackupPath:(NSString *)aBackupPath;

- (NSArray *)databaseNames;
- (void)setDatabaseNames:(NSArray *)aDatabaseNames;

- (id)launchdStartCalendarInterval;

- (BOOL)isScheduleEqual:(MCBackupSchedule *)other;

@end
